; set-up the assignment module
; 
; bound to the 'Assignment' button in the Mode menu
;

set att_version := 0.2
; first check if sh is available
set tmp = ('/tmp/gifa' / 100000*int($random))
open $tmp       ; create the file
fprint $tmp 'coucou'
close $tmp

sh ('pwd >'; $tmp)     ; change its content
open $tmp
set l = <$tmp
close $tmp

if ($l s= 'coucou') then    ; if it did not change -> sh does not workf
   dialogbox 'Error' \
      'The sh command does not work !' message \
      'The assignment module cannot work without it' message \
      separator \
      'This is probably due to a shortage in central memory' message \
      'Try - using a smaller version of Gifa' message \
      '    - quitting some unneeded programs running on this station' message \
      '    - buying some more MegaBytes' message \
      *
      error 'SH does not work'
endif
sh ('/bin/rm'; $tmp)

if (index($gifapath,"att")==0) setpath ("/usr/local/gifa/macro/att" ; $gifapath)

disp2d 0 
cdisp2d 1
disp1d 0
unit p
basic_db.g

closebutton
env_base.g
env_peak.g

buttonbox project \
   "Help (Short)" help_assign \
   separator \
   "New project" "new_proj" \
   "Select project" select_proj \
   "Change param." ch_param \
   "Save data-bases" save_db \
   "Make backup" 'sh "mv backup.tar backup.tar.old; cd db; tar cvf ../backup.tar *"' \
   separator \
   "File selector" read_file \
   "Add spectra" add_spec \
   "Add PDB file" add_pdb \
   'Stat on Primary seq' stat_primary \
   separator \
   'Copy pk to db' pk->att \
   'Rem unassigned peaks' rem_unass_att \
   'Copy the db from another data-set ' copy_att \
   'Merge the peak table into the db' merge_pkatt \
   separator \
   'Quit assignment'  quit_assign \
   *
buttonbox data-bases \
   'Show database' show_curr \
   'Show unassigned peaks' show_unass \
   'Show selected peaks' grep_peak \
   separator \
   'Find a peak' find_att \
   'Edit a peak' edit_att \
   'Create new peak' add_att \
   separator \
   'Find a spin' find_spin \
   'Edit a spin' edit_spin \
   'Create new spin' add_spin \
   'List all spins' list_all_spin \
   separator \
   'Find a syst' find_sys \
   'Edit a syst' edit_sys \
   'List all systs' list_all_sys \
   'Stat on systs' stat_sys \
   separator \
   'Search spins' search_spin \
   separator \
   'Draw noesy walk' draw_noesy_walk \
   'Show Primary seq' show_prim_seq \
   *
buttonbox 'graph-tools' \
	'Choose base color' choose_scolor \
	Point point \
	Marker marker \
        separator \
	"Reset build-list" "set build_list := ' '" \
	"Print build-list" "print $build_list" \
	"Show build-list" 'show_build_list $build_list'\
	separator \
	"Add peak to list" "find_att if ($returned != 0) set build_list := ($returned; $build_list)" \
	"Edit build list" edit_build_list \
	separator \
	"Promote to spin syst" "promote $build_list" \
	*

buttonbox utilities \
   'Check data bases (kind of slow)' dbck \
   'Check topology of spin systs' topock \
   'Low level Editor' low_level \
   'Find distances' find_dist \
   separator \
   'Peak Listing (slow!)' list_att \
   'Spin Listing (slow!)' list_spin \
   'System Listing' list_sys \
   'Assignment Listing' list_assign \
   separator \
   'Plot database' plot_curr \
   'Plot one label' plot_label \
   *

buttonbox "Integration" \
   "Help (Short)" help_intana \
   separator \
   'Single data-set integration tool' integ_att \
   'Choose the calibration intensities' calib_integ \
   'Write build_up constraints file' cnst_buildup \
   'Write qualitative constraints file' cnst_qualit \
   separator \
   'Copy db to a peak file (slow!)' att->fil \
   "Read peak file" "dialogbox Read 'Enter file name' message ' '  file _f $name * pkread $_f unset _f" \
   'PkList' 'pklist %%' \
   'ShowPeaks' showpeaks \
   separator \
   'Eval noise' 'evaln.g' \
   'Integ ' 'alert ("Integ will erase the current amoeba: do you want to continue ?") integ %%' \
   'Show Amoeba' 'Show Amoeba' \
   'Modify Amoeba' mdfamb \
    'Read Peaks/Amoeba' "dialogbox 'Read Amoeba' 'Enter file basename' message ' '  file _f $pkname * mskread $_f unset _f" \
   'Save Peaks/Amoeba' saveamb \
   separator \
   'Multiple integration tool' mult_integ \
   'Show integration curve' show_curve \
   'Peak movie' film_form \
   *

; build a list of peaks
set build_list := ' '

; last clicked datum
set last_click := ' '

alert "Choose either 'New project' or 'Select project' from  the 'project' menu"

print ("Assignment module Version :"; $att_version)

