; set-up the assignment module
; 
; bound to the 'Assignment' button in the Mode menu
;

set att_version := 0.1

if (index($gifapath,"att")==0) setpath ("/usr/local/gifa/macro/att" ; $gifapath)

disp2d 0 
cdisp2d 1
disp1d 0
unit p
basic_db.g

closebutton
env_base.g
env_peak.g

buttonbox project \
   "New project" "new_proj" \
   "Select project" select_proj \
   "change param." ch_param \
   "Save data-bases" save_db \
   separator \
   "File selector" read_file \
   "Add spectra" add_spec \
   separator \
   multi_zoom multi_zoom \
   'Choose base color' choose_scolor \
   separator \
   'Quit assignment'  quit_assign \
   *
buttonbox data-bases \
   'Copy pk to database' pk->att \
   'Show database' show_curr \
   separator \
   'Find a peak' find_att \
   'Edit a peak' edit_att \
   'Add a peak' add_att \
   'List all peaks' list_att \
   separator \
   'Find a spin' find_spin \
   'Edit a spin' edit_spin \
   'Add a spin' add_spin \
   'List all spins' list_spin \
   separator \
   'Find a syst' find_sys \
   'Edit a syst' edit_sys \
   'List all systs' list_sys \
   separator \
   'List assignment' list_assign \
   'Show Primary seq' show_prim_seq \
   *
buttonbox 'graph tools' \
	point point \
	Marker marker \
        separator \
	"Reset build-list" "set build_list := ' '" \
	"Print build-list" "print $build_list" \
	"Show build-list" 'show_build_list $build_list'\
	separator \
	"Add peak to list" "find_att if ($returned != 0) set build_list := ($returned; $build_list)" \
	"Edit build list" edit_build_list \
	separator \
	"Promote to spin-sys" "promote $build_list" \
	*
; build a list of peaks
set build_list := ' '

; last clicked datum
set last_click := ' '

alert "Choose either 'New project' or 'Select project' from  the 'project' menu"

print ("Assignment module Version :"; $att_version)

