/* Header for module NMRPAR, generated by p2c */
/* Edited manually by G.Salnikov, Novosibirsk */
#ifndef NMRPAR_H
#define NMRPAR_H

/*
    Corresponds to DISNMR 880101.1 version.

   This unit defines two Pascal record types which should be
   used by any programs that manipulate spectral data.  DISPAR
   is the name of a record type corresponding to the structure
   of the "-1" sector of a spectral data file.  AQPAR is the
   name of a record type corresponding to the in-memory
   acquisition parameters.  Note that these parameters also
   make up part of the DISPAR record.  This version is
   specifically for DISNMR files.  Similar record definitions
   are also available for CXP or MSL data files.

   The names of the fields in the record are the same as the
   names of the acquisition and processing parameters defined
   in the DISNMR manual.

   The following simple example illustrates how this record
   definition can be used in a Pascal program:


  Written by Leo Joncas, Bruker Instruments, Billerica MA USA
*/

typedef unsigned char FDT_ARRAY[48];
typedef unsigned char COM_ARRAY[72];

typedef struct integer {
  unsigned char h;
  unsigned char m;
  unsigned char l;
} INTEGER;

typedef struct real {
  unsigned char hh;
  unsigned char hm;
  unsigned char hl;
  unsigned char lh;
  unsigned char lm;
  unsigned char ll;
} REAL;

typedef struct AQPAR {
  INTEGER ASIZE;   /* Size of data in file */
  INTEGER GLOBEX;   /* Data normalization constant */
  INTEGER SWPCOM;   /* Count of sweeps done */
  INTEGER TDSIZE;   /* Time domain size */
  INTEGER DWELLT;   /* Dwell time */
  INTEGER FWIDTH;   /* Filter width */
  INTEGER FN;   /* Filter number */
  INTEGER F1N;   /* O1 divider settings */
  INTEGER F1M, F2N;   /* O2 divider settings */
  INTEGER F2M, VDELAY;   /* Variable delay */
  INTEGER DSCANS;   /* # of dummy scans */
  REAL SPWIDTH;   /* Spectral width */
  INTEGER AQMODE;   /* Acquisition mode */
  INTEGER TEXP;   /* Total count of experiments done */
  REAL O1;   /* Observation frequency */
  REAL O2;   /* Decoupling frequency */
  INTEGER DUMMY1, DUMMY2;
  REAL TOTLB;   /* Total EM (Hz) applied */
  REAL NTHPT;   /* Nth point of FT */
  INTEGER CRDEL;   /* Relaxation delay */
  INTEGER CPULSE;   /* PW excitation pulse */
  INTEGER CDELAY;   /* Pre-acquisition delay */
  INTEGER CSWEEP;   /* Scans to do */
  INTEGER DRSTR;   /* Digital resolution */
  INTEGER DREND;   /* Lowest allowed DRSTR */
  INTEGER DRSET;   /* Largest allowed DRSTR */
  INTEGER CSPDEL;   /* Initial SP delay */
  INTEGER PHZFLG;   /* A0-A3 phase shift */
  INTEGER ORIGPS;   /* Original parameters flag */
  REAL SFREQ;   /* Spectrometer frequency */
  INTEGER QUAFLG;   /* Quadrature flag */
  INTEGER DCTRLW;   /* Digitizer control word */
  INTEGER DATTEN;   /* Decoupler attenuation */
  INTEGER DEUTL;   /* Deuterium lock setting */
  INTEGER HARFLG, PAPS, TEMPER;   /* Temperature */
  INTEGER DATASTAT, CPCUR, RGAIN;   /* Receiver gain */
  INTEGER SYNCW1;   /* Synthesizer control words */
  INTEGER SYNCW2, IMZYAXIS, IMFLAGS, YXRATIO, PD0INC;   /* Increment for DUR0 */
  INTEGER PARSET;   /* Parameter set identifier */
  INTEGER SYNCW3;   /* More synthesizer control words */
  INTEGER SYNCW4;
  REAL SFREQ0, FX2;   /* Initial O2 divider */
  INTEGER DFXI;   /* Divider increment */
  INTEGER SAUNM1;   /* AU program name */
  INTEGER SAUNM2, SAUEXT, DUMMY3, F1CW;   /* Offset frequency control word */
  INTEGER F2CW;   /* Decoupler control word */
  INTEGER DUR0;   /* Delays */
  INTEGER DUR1, DUR2, DUR3, DUR4, DUR5, DUR6, DUR7, DUR8, DUR9, DPS0;
      /* Decoupler power settings */
  INTEGER DPS1, DPS2, DPS3, DPS4, DPS5, DPS6, DPS7, DPS8, DPS9, PLSW0;
      /* Pulse widths */
  INTEGER PLSW1, PLSW2, PLSW3, PLSW4, PLSW5, PLSW6, PLSW7, PLSW8, PLSW9, D9VAR;
      /* Max percent variation in DUR9 */
  INTEGER ROFREQ;   /* Rotation frequency */
  INTEGER FMFLAG;   /* Frequency mode flag */
  INTEGER FIXFLG, P2DOFF;   /* Offset to 2D parameters */
  INTEGER VDSCALE, ACQDATE;   /* Date of acquisition */
  INTEGER ACQTIME;   /* Time of acquisition */
  INTEGER TWODFLG, XSA;   /* Current plot area */
  INTEGER XSIZE, SVSA;   /* Most recent expanded area */
  INTEGER SVSIZE, HZPMFG;   /* Hz/PPM flag for EP frequencies */
  REAL FREQ1;   /* Left frequency limit of plot */
  REAL FREQ2;   /* right frequency limit of plot */
  REAL OFFSET;   /* offset of spectrum */
  REAL RFREQ;   /* spectrum reference frequency */
  REAL HZPCM;   /* Hz/cm of plot area */
  INTEGER IDSCALE;   /* integral scaling factor */
  REAL INTSCL;   /* integral normalization factor */
  INTEGER SVTHTA;   /* zero order phase angle */
  INTEGER SVADDI;   /* first order phase angle */
  INTEGER MIN_INT;   /* peak picking minimum intensity */
  INTEGER PPSIGN;   /* peaks allowed flag */
  REAL PCONS;   /* peak picking sensitivity */
  REAL PVSIZE;   /* distance between marks in Hz */
  INTEGER PVHZPM;   /* Hz or PPM flag for PV */
  REAL MARKSZ;   /* size of mark in cm */
  REAL PVOFF;   /* PV offset fro 0 in cm */
  INTEGER YMAX;   /* intensity of largest point */
  INTEGER AIFLAG;   /* absolute intensity scaling */
  INTEGER AINORM;   /* normalization factor for AI */
  INTEGER INTFAC;   /* Factor for AZF integral level */
  INTEGER DUMMY4;   /* unused */
  REAL FP0K;   /* zero order phase correction */
  REAL FP1K;   /* first order */
  REAL LBROAD;   /* line broadening factor for EM */
  REAL GBROAD;   /* gaussian line broadening */
  INTEGER WTTYPE;   /* window table type */
  INTEGER SBSHFT;   /* sine-bell shift */
  INTEGER ZPNUM;   /* points to zero at start */
  INTEGER T1PT;   /* trapezoidal mult. left limit */
  INTEGER T2PT;   /* trapezoidal mult. right limit */
  INTEGER SMCTR;   /* smoothing count */
  REAL GAMMA;   /* amplitude unbalance */
  REAL ALPHA;   /* phase error term */
  REAL VCHTY;   /* variable height of plot */
  REAL VCHTX;   /* variable length of plot */
  REAL POYCM;   /* Y plot offset in cm */
  REAL POXCM;   /* X offset */
  INTEGER PENLOC;   /* Initial plot position */
  INTEGER PENLOC2;   /* Plot types */
  INTEGER DPSPD;   /* speed for data plots */
  INTEGER PVSPD;   /* plot grid speed */
  INTEGER DPOPT;   /* DP option specifier */
  INTEGER DUMMY5, TOBLOC;   /* destination block for transfer */
  REAL DCON;   /* constant for additive transfer */
  REAL T1CONF;
  INTEGER T1DRIFT, CEXP, NFIDS;
  REAL PLOHEI;   /* Plot height */
} AQPAR;

/*
   The following declaration corresponds to the structure
   of the -1 sector of a spectral data file.

   The dummy array is present merely to insure that when a
   BLOCKREAD is performed, the data structure is large enough
   to accomodate an entire disk sector.
*/

typedef union DISPAR {
  unsigned char DUM_ARRAY[768];
  struct {
    /* Begin variant declaration */
    FDT_ARRAY FDTINFO;   /* File Definition Table */
    COM_ARRAY COMMTARY;   /* File Commentary */
    AQPAR AQREC;   /* Acquisition Parameters */
  } U1;
} DISPAR;

#endif /*NMRPAR_H*/

/* End. */
