# graphicx.perl  by Ross Moore  <ross@mpce.mq.edu.au>  98/1/7
# same as ...
#
# graphics.perl by Herbert Swan <dprhws.edp.Arco.com>  12-22-95
#
# Extension to LaTeX2HTML V 96.1 to supply support for the "graphics"
# and "graphicx" standard LaTeX2e packages.
#
# extended and revised for LaTeX2HTML V 98.1 
# by Ross Moore <ross@mpce.mq.edu.au>  98/1/7
#
# Change Log:
# ===========

package main;

# Suppress option-warning messages:

sub do_graphics_dvips {
}
sub do_graphicx_dvips {
}



sub do_cmd_graphicspath {
    local($_) = @_;
    local($paths);
    $paths = &missing_braces unless (
	(s/$next_pair_pr_rx/$paths=$2;''/e)
	||(s/$next_pair_rx/$paths=$2;''/e));
    $paths = &revert_to_raw_tex($paths);

    #RRM: may only work correctly for Unix    
    # $dd  holds the directory-delimiter, usually / 
    $paths =~ s/\s*({|})\s*/$1/g;
    local(@paths) = split (/}/, $paths);
    if ($DESTDIR eq $FILE) {
	# given paths are relative to parent directory
	map(s|^{([^/~\.\$\\][^}]*)|{..\Q$dd\E$1|, @paths);
	map(s/^{\.\Q$dd\E/{\.\.\Q$dd\E/, @paths);
    } elsif ($DESTDIR eq '.') {
	# paths are already relative to working directory
    } else { 
	# specify full paths, by prepending source directory
	map(s|^{([^/~\.\$\\][^}]*)|{$orig_cwd\Q$dd\E$1|, @paths);
	map(s/^{\.\Q$dd\E/{$orig_cwd\Q$dd\E/, @paths);
    }
    $paths = join('}', @paths).'}';
    $latex_body .= "\n\\graphicspath{$paths}\n\n" unless ($PREAMBLE);
    $_
}

sub do_cmd_DeclareGraphicsRule {
    local($_) = @_;
    local($arg1,$arg2,$arg3,$arg4);
    $arg1 = &missing_braces unless (
	(s/$next_pair_pr_rx/$arg1=$&;''/e)
	||(s/$next_pair_rx/$arg1=$&;''/e));
    $arg2 = &missing_braces unless (
	(s/$next_pair_pr_rx/$arg2=$&;''/e)
	||(s/$next_pair_rx/$arg2=$&;''/e));
    $arg3 = &missing_braces unless (
	(s/$next_pair_pr_rx/$arg3=$&;''/e)
	||(s/$next_pair_rx/$arg3=$&;''/e));
    $arg4 = &missing_braces unless (
	(s/$next_pair_pr_rx/$arg4=$&;''/e)
	||(s/$next_pair_rx/$arg4=$&;''/e));

    # need a full path to the filename
    $arg4 =~ s/(\#1)/$orig_cwd$dd$1/g
	unless ($arg4 =~ /^\Q$dd\E|\Q$env_key\E/);

    $latex_body .= "\n".&revert_to_raw_tex(
	'\DeclareGraphicsRule'.$arg1.$arg2.$arg3.$arg4)."\n";
    $_;
}

&process_commands_wrap_deferred (<<_RAW_ARG_CMDS_);
graphicspath # {}
_RAW_ARG_CMDS_

&process_commands_in_tex (<<_RAW_ARG_CMDS_);
rotatebox # [] # {} # {}
scalebox # {} # [] # {}
reflectbox # {}
resizeboxstar # {} # {} # {}
resizebox # {} # {} # {}
includegraphicsstar # [] # [] # {}
includegraphics # [] # [] # {}
_RAW_ARG_CMDS_

&process_commands_nowrap_in_tex (<<_RAW_ARG_CMDS_);
DeclareGraphicsExtensions # {}
#DeclareGraphicsRule # {} # {} # {} # {}
psfragstar # {} # {}
psfrag # {} # {}
_RAW_ARG_CMDS_


&ignore_commands( <<_IGNORED_CMDS_);
setkeys # {} # {}
_IGNORED_CMDS_


1;	# Must be last line
