#include "Config.h"
#include <fstream.h>
#include <stdlib.h>
#include <string.h>
#include "defines.h"

char *strstrip(char *str)
{
    while(*str == ' ' || *str == '\t')
        str++;
    int len;
    while((len = strlen(str)) && (str[len-1] == ' ' || str[len-1] == '\t'))
        str[len-1] = '\0';
    return str;
}

int CConfig::ReadConfig(const char *filename)
{
    ifstream ifs(filename);
    if(!ifs)
        return 0;

    char buf[BUFSIZE], *ptr;

    while(!ifs.eof())
    {
        ifs.getline(buf, BUFSIZE-1);

        if(ptr = strchr(buf, '#'))
            *ptr = '\0';
        if(!buf[0])
            continue;

        ptr = strpbrk(buf, " \t");
        if(!ptr)
            continue;
        *ptr = '\0';
        strstrip(buf);
        ptr++;
        strstrip(ptr);

        if(!strcasecmp(buf, "nntpserver"))
            nntpserver = strdup(ptr);
        else if(!strcasecmp(buf, "nntpport"))
            nntpport = atoi(ptr);
        else if(!strcasecmp(buf, "smtpserver"))
            smtpserver = strdup(ptr);
        else if(!strcasecmp(buf, "smtpport"))
            smtpport = atoi(ptr);
        else if(!strcasecmp(buf, "from"))
            from = strdup(ptr);
        else if(!strcasecmp(buf, "to"))
            to = strdup(ptr);
        else if(!strcasecmp(buf, "logfile"))
            logfile = strdup(ptr);
    }

    if(!nntpserver)
        nntpserver = strdup("localhost");
    if(!nntpport)
        nntpport = 119;
    if(!smtpserver)
        smtpserver = strdup("localhost");
    if(!smtpport)
        smtpport = 25;
    if(!from)
        from = strdup("News Digest <digest@news2mail.com>");
    if(!to)
        to = strdup("Digest Recipients <digest@news2mail.com>");

    ifs.close();
    return 1;
}

int CConfig::ReadGroups(const char *filename)
{
    ifstream ifs(filename);
    if(!ifs)
        return 0;

    char buf[BUFSIZE];
    char *ptr;
    char email[100] = "";
    CGroup *group = NULL;
    
    while(!ifs.eof())
    {
        ifs.getline(buf, BUFSIZE-1);

        if(!buf[0])
            continue;
        if(buf[0] == '*')
        {
            if(group)
            {
                groups.AddItem(*group);
                delete group;
            }
            group = new CGroup;

            ptr = strtok(buf+1, ":");
            group->groupname = strdup(ptr);
            ptr = strtok(NULL, ":");
	    if(*ptr == '#')
	    {
		group->artnum = new char[20];
		if(!*(ptr+1))
		    strcpy(group->artnum, "-1");
		else
		    strcpy(group->artnum, ptr+1);
		group->type = BY_ARTNUM;
	    }
	    else
	    {
		group->date = strdup(ptr);
		ptr = strtok(NULL, ":");
		group->time = strdup(ptr);
		group->type = BY_DATE;
	    }
        }
        else
        {
            if(!group) continue;
            ptr = strdup(buf);
            group->emails.AddItem(ptr);
        }
    }

    if(group)
    {
        groups.AddItem(*group);
        delete group;
    }
    ifs.close();
    return 1;
}

int CConfig::WriteGroups(const char* filename)
{
    ofstream ofs(filename);
    if(!ofs)
        return 0;
    
    for(int i=0; i<groups.GetNumItems(); i++)
    {
        CGroup group = groups.GetAt(i);
        ofs << '*' << group.groupname << ':';
	if(group.type == BY_ARTNUM)
	    ofs << '#' << group.artnum << endl;
	else if(group.type == BY_DATE)
	    ofs << group.date << ':' << group.time << endl;
        for(int j=0; j<group.emails.GetNumItems(); j++)
            ofs << group.emails.GetAt(j) << endl;
        ofs << endl;
    }

    ofs.close();
    return 1;
}

CConfig::~CConfig()
{
    free(nntpserver);
    free(smtpserver);
    free(from);
    free(to);
    if(logfile) free(logfile);
    for(int i=0; i<groups.GetNumItems(); i++)
    {
        CGroup group = groups.GetAt(i);
        free(group.groupname);
        if(group.type == BY_DATE)
	{
	    free(group.date);
	    free(group.time);
	}
	else if(group.type == BY_ARTNUM)
	    free(group.artnum);
        for(int j=0; j<group.emails.GetNumItems(); j++)
            free(group.emails.GetAt(j));
    }
}
