#include <time.h>
#include <string.h>
#include "Socket.h"
#include "Digest.h"
#include "Log.h"
#include "responses.h"
#include "defines.h"

int CDigest::GetResponse(char *userbuf, int bufsize)
{
    static char buf[BUFSIZE];
    if(!sock.Receive(buf))
        log.Abort(SSERVERERROR, "SMTP server timed out.\n");

    if(userbuf)
	strncpy(userbuf, buf, bufsize);

    int resplist_size = sizeof(smtp_responses)/sizeof(smtp_responses[0]);
    int i;
    for(i=0; i<resplist_size &&
        strncmp(buf, smtp_responses[i].code, 3); i++);

    if(i==resplist_size)
    {
        log.Abort(SSERVERERROR, "Unrecognized SMTP response: %s\n",
                  buf);
    }
    else
    {
        if(smtp_responses[i].type == RT_OK)
            return smtp_responses[i].exitcode;
        else if(smtp_responses[i].type == RT_WARN)
        {
            log.Warn("SMTP server: %s\n", buf);
            return smtp_responses[i].exitcode;
        }
        else
        {
            log.Abort(smtp_responses[i].exitcode,
                      "SMTP server: %s\n", buf);
            return 0;    // Never gets here anyway
        }
    }
}

void CDigest::AddMessage(CMessage& msg)
{
    char buf[BUFSIZE], from[100], *ptr;

    bodies << "-------------------------------" << endl << endl;
    msg.GetHeader("From: ", buf);
    bodies << "From: " << buf << endl;

    ptr = strchr(buf, '<');
    // Either it's From: one <two@three.com>
    if(ptr && (ptr - buf >= 2))
    {
        *(ptr-1) = '\0';
        strncpy(from, buf, 99);
    }
    // Or it's From: <two@three.com>
    else if(ptr)
    {
        if(buf[strlen(buf)-1] == '>')
            buf[strlen(buf)-1] = '\0';
        strncpy(from, ptr+1, 99);
    }
    else
    {
        ptr = strchr(buf, '(');
        // Or it's From: two@three.com (one)
        if(ptr)
        {
            if(buf[strlen(buf)-1] == ')')
                buf[strlen(buf)-1] = '\0';
            strncpy(from, ptr+1, 99);
        }
        // Or it's From: two@three.com
        else
            strncpy(from, buf, 99);
    }

    msg.GetHeader("Subject: ", buf);
    subjs << buf << " (" << from << ')' << endl;
    bodies << "Subject: " << buf << endl;
    msg.GetHeader("Date: ", buf);
    bodies << "Date: " << buf << endl << endl;

    msg.body.Rewind();
    while(!msg.body.eof())
    {
        msg.body.getline(buf, BUFSIZE-1);
        bodies << buf << endl;
    }
    bodies << endl;
}


void CDigest::SendDigest()
{
    subjs.Rewind();
    bodies.Rewind();

    char buf[BUFSIZE];
    int counter = 0, i;

    log.Log("Connecting to SMTP server\n");
    if(!sock.Connect(cfg.smtpserver, cfg.smtpport))
        log.Abort(CCSSERVER, "Error connecting to SMTP"
            " server, %s:%d\n", cfg.nntpserver, cfg.nntpport);
    GetResponse();

    log.Log("Sending the digest");
    sock.Send("MAIL FROM:<digest@news2mail.com>\n");
    GetResponse();

    for(i=0; i<group.emails.GetNumItems(); i++)
    {
        sock.Send("RCPT TO:<%s>\n", group.emails.GetAt(i));
        GetResponse();
    }

    sock.Send("DATA\n");
    GetResponse();

    sock.Send("From: %s\n", cfg.from);
    sock.Send("To: %s\n", cfg.to);
    sock.Send("Subject: Digest: %s\n", group.groupname);
    sock.Send("\n");


    strcpy(buf, group.groupname);
    for(i=0; i<50-strlen(group.groupname); i++)
         strcat(buf, " ");
    time_t tm;
    time(&tm);
    strcat(buf, ctime(&tm));
    strcat(buf, "\n\n");
    sock.Send(buf);

    sock.Send("Contents:\n");
    while(!subjs.eof())
    {
        subjs.getline(buf, BUFSIZE-1);
        sock.Send("  %s\n", buf);
        if(counter++%10 == 0)
            log.Log(".");
    }
    sock.Send("\n");

    while(!bodies.eof())
    {
        bodies.getline(buf, BUFSIZE-1);
        sock.Send("%s\n", buf);
        if(counter++%10 == 0)
            log.Log(".");
    }
    sock.Send(".\n");
    GetResponse();

    sock.Send("QUIT\n");
    log.Log("\n");
    sock.Disconnect();
}
