#ifndef __DIGEST_H
#define __DIGEST_H

#include "Socket.h"
#include "Message.h"
#include "Temp.h"
#include "Config.h"
#include "Log.h"
#include "defines.h"

class CDigest
{
public:
    // (Con|De)structors
    CDigest(CLog& _log, CConfig& _cfg) : log(_log), cfg(_cfg) {}

    // Methods
    void Init(const CGroup& _group);

    void AddMessage(CMessage& msg);
    void SendDigest();

protected:
    // Methods
    int GetResponse(char *userbuf = NULL, int bufsize = 0);

    // Data
    CLog& log;
    CConfig& cfg;
    CGroup group;
    CTemp subjs, bodies;
    CSocket sock;
};

inline void CDigest::Init(const CGroup& _group)
{
    group = _group;
    subjs.Clear();
    bodies.Clear();
}

#endif //__DIGEST_H
