#ifndef __GROUP_H
#define __GROUP_H

#include "List.h"

enum e_type { BY_ARTNUM, BY_DATE };

class CGroup
{
public:
    // (Con|De)structors
    CGroup() {}
    CGroup(const CGroup& src);

    // Operators
    CGroup& operator=(const CGroup& src);

    // Data
    char *groupname;
    char *date, *time;
    char *artnum;
    e_type type;
    CList<char*> emails;
};

inline CGroup::CGroup(const CGroup& src)
{
    groupname = src.groupname;
    date = src.date;
    time = src.time;
    artnum = src.artnum;
    type = src.type;
    emails = src.emails;
}

inline CGroup& CGroup::operator=(const CGroup& src)
{
    if(&src == this)
        return *this;
    groupname = src.groupname;
    date = src.date;
    time = src.time;
    artnum = src.artnum;
    type = src.type;
    emails = src.emails;
    return *this;
}

#endif //__GROUP_H
