#ifndef __CLIST_H
#define __CLIST_H

#include <stdio.h>
#include <assert.h>

template <class T>
class CList
{
public:
    
    CList() : numitems(0), items(NULL) {}
    CList(const CList& src);
    ~CList() { DeleteAll(); }

    int InsertItem(T item, int place);
    int AddItem(T item)
        { return InsertItem(item, numitems); }
    void DeleteItem(int place);
    void DeleteAll();
    T GetAt(int place) const;
    void SetAt(T item, int place);
    int GetNumItems() const
        { return numitems; }

    CList& operator=(const CList& src);

protected:
    struct ITEM
    {
        T item;
        ITEM* next;
    } *items;
    int numitems;
};

template <class T>
CList<T>::CList(const CList& src)
    : numitems(0), items(NULL)
{
    for(int i=0; i<src.GetNumItems(); i++)
        AddItem(src.GetAt(i));
}

template <class T>
int CList<T>::InsertItem(T item, int place)
{
    assert(place >= 0 && place <= numitems);

    ITEM *newitem = new ITEM;
    if(!newitem)
        return 0;
    newitem->item = item;

    if(place == 0)
    {
        newitem->next = items;
        items = newitem;
    }
    else if(place <= numitems)
    {
        ITEM *ptr = items;
        for(int i=0; i<place-1; i++)
            ptr = ptr->next;
        newitem->next = ptr->next;
        ptr->next = newitem;
    }

    numitems++;
    return 1;
}

template <class T>
void CList<T>::DeleteItem(int place)
{
    assert(place >= 0 && place < numitems);
    
    ITEM *ptr;

    if(place == 0)
    {
        ptr = items;
        items = items->next;
    }
    else
    {
        ITEM *ptr2 = items;
        for(int i=0; i<place-1; i++)
            ptr2 = ptr2->next;
        ptr = ptr2->next;
        ptr2->next = ptr->next;
    }

    delete ptr;
    numitems--;
}

template <class T>
void CList<T>::DeleteAll()
{
    while(numitems)
        DeleteItem(0);
}

template <class T>
T CList<T>::GetAt(int place) const
{
    assert(place >= 0 && place < numitems);

    ITEM *ptr = items;
    for(int i=0; i<place; i++)
        ptr = ptr->next;

    return ptr->item;
}

template <class T>
void CList<T>::SetAt(T item, int place)
{
    assert(place >= 0 && place < numitems);

    ITEM *ptr = items;
    for(int i=0; i<place; i++)
        ptr = ptr->next;
    ptr->item = item;
}

template <class T>
CList<T>& CList<T>::operator=(const CList<T>& src)
{
    if(&src == this)
        return *this;
    
    DeleteAll();
    for(int i=0; i<src.GetNumItems(); i++)
        AddItem(src.GetAt(i));

    return *this;
}

#endif //__CLIST_H
