#include <stdio.h>
#include <stdlib.h>
#include "Log.h"
#include "defines.h"

#ifdef USE_VSNPRINTF
#define FMTSTR() \
    char buf[BUFSIZE]; \
    va_list vl; \
    va_start(vl, fmt); \
    vsnprintf(buf, BUFSIZE-1, fmt, vl); \
    va_end(vl);
#else
#define FMTSTR() \
    char buf[BUFSIZE]; \
    va_list vl; \
    va_start(vl, fmt); \
    vsprintf(buf, fmt, vl); \
    va_end(vl);
#endif


void CLog::Log(char *fmt, ...)
{
    FMTSTR()

    if(!quiet)
        cout << buf, cout.flush();
    if(flogging)
        fs << buf, fs.flush();
}

void CLog::Warn(char *fmt, ...)
{
    FMTSTR()

    if(quiet < 2)
        cerr << "WARNING: " << buf, cerr.flush();
    if(flogging)
        fs << "WARNING: " << buf, fs.flush();
}

void CLog::Abort(int code, char *fmt, ...)
{
    FMTSTR()

    if(quiet < 2)
        cerr << "FATAL: " << buf, cerr.flush();
    if(flogging)
        fs << "FATAL: " << buf, fs.flush();

    exit(code);
}
