#ifndef __LOG_H
#define __LOG_H

#include <stdarg.h>
#include <time.h>
#include <fstream.h>

class CLog
{
public:
    // (Con|De)structors
    CLog() : flogging(0), quiet(0) {}
    ~CLog() { if(fs.is_open()) fs.close(); }

    // Methods
    int Init(char *fname);
    void ShutUp(int _quiet = 1)
        { quiet = _quiet; }

    void Log(char *fmt, ...);
    void Warn(char *fmt, ...);
    void Abort(int code, char *fmt, ...);

protected:
    // Data
    ofstream fs;
    int flogging;
    int quiet;
};


inline int CLog::Init(char *fname)
{
    if(fname)
    {
        flogging = 1;
        fs.open(fname, ios::out | ios::app);
        if(!fs)
            return 0;
        else
        {
            time_t t;
            time(&t);
            fs << endl << "--------- " << ctime(&t);
            return 1;
        }
    }
    return 1;
}


#endif // __LOG_H
