#ifndef __SERVER_H
#define __SERVER_H

#include "Socket.h"
#include "Message.h"
#include "Temp.h"

#include <fstream.h>
#include "Group.h"
#include "Log.h"
#include "defines.h"

class CServer
{
public:
    // (Con|De)structors
    CServer(CLog& _log) : log(_log) {}

    // Methods
    void Connect(const char *hostname, unsigned short port);
    void Disconnect();

    int SetGroup(CGroup& group);
    int GetNextMessage(CMessage& msg);
    int GetGroupList(ostream& str);


protected:
    // Methods
    int GetResponse(char *userbuf = NULL, int bufsize = 0);

    // Data
    CLog& log;
    CSocket sock;
    CTemp msgids;
};

#endif //__SERVER_H
