#include "Socket.h"
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <sys/time.h>
#include "defines.h"

int CSocket::Connect(const char *host, unsigned short port)
{
    int a,b,c,d;
    struct hostent *hent;
    char rmt_host[100];
    struct sockaddr_in addr;

    if (sscanf(host,"%d.%d.%d.%d",&a,&b,&c,&d) != 4)
    {
        hent = gethostbyname(host);
        if(hent == NULL)
        {
#ifndef NDEBUG
            perror("gethostbyname");
#endif
            return 0;
        }
        sprintf(rmt_host,"%d.%d.%d.%d",
            (unsigned char) hent->h_addr_list[0][0],
            (unsigned char) hent->h_addr_list[0][1], 
            (unsigned char) hent->h_addr_list[0][2], 
            (unsigned char) hent->h_addr_list[0][3]);
    } else {
        strncpy(rmt_host,host,99);
    }

    sockfd = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if(sockfd < 0)
    {
#ifndef NDEBUG
        perror("socket");
#endif
        return 0;
    }

    addr.sin_family = AF_INET;
    addr.sin_port = htons(port);
    if((addr.sin_addr.s_addr = inet_addr(rmt_host)) == -1)
    {
#ifndef NDEBUG
        perror("inet_aton");
#endif
        return 0;
    }

    a = connect(sockfd, (struct sockaddr*)&addr, sizeof(addr));
    if(a < 0)
    {
#ifndef NDEBUG
        perror("connect");
#endif
        return 0;
    }
    return 1;
}

int CSocket::Disconnect()
{
    return (close(sockfd) == 0);
}

int CSocket::Send(char *str, ...)
{
    char buf[BUFSIZE];

    va_list args;
    va_start(args, str);
#ifdef USE_VSNPRINTF
    vsnprintf(buf, BUFSIZE-1, str, args);
#else
    vsprintf(buf, str, args);
#endif
    va_end(args);

#ifndef NDEBUG
    printf("Sending: %s\n", buf);
#endif

    return send(sockfd, buf, strlen(buf), 0);
}

int CSocket::Receive(char *str)
{
    char buf[2];
    buf[0]=0;
    int read = 0, globread = 0;
    time_t btime = time(NULL);
    long waited = 0;
    fd_set rfds;
    struct timeval tv;

    str[0]=0;

    while(globread == 0 || buf[0] != '\n')
    {
        FD_ZERO(&rfds);
        FD_SET(sockfd, &rfds);
        tv.tv_sec = READ_TIMEOUT - waited;
        tv.tv_usec = 0;
        if(!select(sockfd+1, &rfds, NULL, NULL, &tv))
            return 0;
        waited = time(NULL) - btime;

        read = recv(sockfd, buf, 1, 0);
        buf[1] = 0;
        strcat(str, buf);
        globread += read;
    }
    while(str[strlen(str)-1] == '\r' || str[strlen(str)-1] == '\n')
        str[strlen(str)-1] = 0;

#ifndef NDEBUG
    printf("Received: %s\n", str);
#endif

    return globread;
}

