#ifndef __TEMP_H
#define __TEMP_H

#include <stdio.h>
#include <unistd.h>
#include <fstream.h>

class CTemp : public fstream
{
public:
    // (Con|De)structors
    CTemp();
    ~CTemp();

    // Methods
    void Clear();
    void Rewind();

protected:
    // Data
    char fname[L_tmpnam];
};

inline CTemp::CTemp()
    : fstream::fstream()
{
    tmpnam(fname);
    open(fname, ios::in | ios::out);
}

inline CTemp::~CTemp()
{
    close();
    unlink(fname);
}

inline void CTemp::Clear()
{
    close();
    unlink(fname);
    tmpnam(fname);
    open(fname, ios::in | ios::out);
}

inline void CTemp::Rewind()
{
    rdbuf()->seekoff(0, ios::beg);
    clear();
}

#endif //__TEMP_H
