#!/usr/local/bin/perl
#
# Process the mail request for subscription/unsubscription
#

#############################################################################
################################## Configuration

$SENDMAIL = '/usr/lib/sendmail -t';
$FROM = 'News2Mail Control <my.address@host.com>';
$SUBSPL = '$HOME/news2mail/subs.pl';
$UNSUBSPL = '$HOME/news2mail/unsubs.pl';
$GROUPSTXT = '$HOME/news2mail/groups.txt';
$LISTFILE = '$HOME/news2mail/groups.zip';

#############################################################################
################################## Main

while(<STDIN>)
{
    chomp;
    if(/^$/)
        { $body = 1; next; }
    if($body)
        { push @body, $_; }
    else
    {
        if(s/^Return-To: //i)
            { $email = $_; }
        elsif(!$email && s/^From: //i)
            { $email = $_; }
    }
}

$email =~ s/^.*<(.*?)>.*$/$1/;
die "No return address\n" if(!$email);

foreach(@body)
{
    if(/^getlist/i)
        { &GetList(); }
    elsif(/^subscribe (.*)/i)
        { &Subs($1, $email); }
    elsif(/^subs (.*)/i)
        { &Subs($1, $email); }
    elsif(/^unsubscribe (.*)/i)
        { &Unsubs($1, $email); }
    elsif(/^unsubs (.*)/i)
        { &Unsubs($1, $email); }
}

if(!$mimemessage)
{
    open SML, "|" . $SENDMAIL or die "Can't run sendmail!\n";
    print SML <<EOF;
From: $FROM
To: $email
Subject: Your request results

$reply
EOF
    close SML;
}
else
{
    open TMP, ">/tmp/$$.reply";
    print TMP $reply;
    close TMP;
    system "mpack -s 'Your request results' -d /tmp/$$.reply -o /tmp/$$.mime $filetoattach";
    open TMP, "/tmp/$$.mime";
    open SML, "|" . $SENDMAIL or die "Can't run sendmail!\n";
    print SML <<EOF;
From: $FROM
To: $email
EOF
    print SML while(<TMP>);
    print SML "\n.\n";
    close SML;
    close TMP;
    unlink "/tmp/$$.reply";
    unlink "/tmp/$$.mime";
}


#############################################################################
################################## Functions

sub GetList
{
    $mimemessage = 1;
    $filetoattach = $LISTFILE;
    $reply .= "List of available newsgroups attached\n";
}

sub Subs
{
    my $group = shift;
    my $email = shift;
    system "$SUBSPL $GROUPSTXT $group $email";
    $reply .= "$email subscribed to $group\n";
}

sub Unsubs
{
    my $group = shift;
    my $email = shift;
    system "$UNSUBSPL $GROUPSTXT $group $email";
    $reply .= "$email unsubscribed from $group\n";
}
