
##########################################################################
################################# Configuration Options

# The default method for subscribing to new groups - "newnews" for using
# the NEWNEWS command, and "artnum" for using article numbers.
#$DEFMETHOD="artnum";
$DEFMETHOD="newnews";

##########################################################################
################################# Functions

sub ReadConfig
{
    my $cfgfile = shift;
    my $group;
    if(! -f $cfgfile) { system "touch $cfgfile"; return; }
    open CFGFILE, $cfgfile or die "$!";
    while(<CFGFILE>)
    {
        chomp;
        next if /^$/;

        if(/^\*(.+?):#?(-?\d+)/)
        {    
            $group = $1;
	    if(/^\*(.+?):(\d+?):(\d+)$/)
	    {
		$dates{$group} = $2;
		$times{$group} = $3;
	    }
	    elsif(/^\*(.+?):#(-?\d+)$/)
	    {
		$artnums{$group} = $2;
	    }
	    else
	    {
		die "Unrecognized groups.txt format.\n";
	    }
        }
        else
        {
            push @{$emails{$group}}, $_;
        }
    }
    close CFGFILE;
}

sub WriteConfig
{
    $,="\n";
    my $cfgfile = shift;
    open CFGFILE, ">" . $cfgfile or die "$!";
    foreach (keys %emails)
    {
	if(defined $dates{$_})
	{
	    print CFGFILE "*$_:$dates{$_}:$times{$_}\n";
	}
	elsif(defined $artnums{$_})
	{
	    print CFGFILE "*$_:#$artnums{$_}\n";
	}
	print CFGFILE @{$emails{$_}};	    
        print CFGFILE "\n\n";
    }
    close CFGFILE;
}

##########################################################################
################################# End
1;
