#ifndef __RESPONSES_H
#define __RESPONSES_H

enum e_rtype { RT_ABORT, RT_WARN, RT_OK };

struct RESP
{
    char *code;
    e_rtype type;
    int exitcode;
};

enum { OK_OK=1, OK_NOSUCHART };

const RESP nntp_responses[] =
{
    "200", RT_OK,     OK_OK,
    "201", RT_OK,     OK_OK,
    "205", RT_OK,     OK_OK,
    "211", RT_OK,     OK_OK,
    "221", RT_OK,     OK_OK,
    "222", RT_OK,     OK_OK,
    "230", RT_OK,     OK_OK,
    "235", RT_OK,     OK_OK,
    "400", RT_ABORT,  NSERVERERROR,
    "411", RT_OK,     OK_NOSUCHART,
    "423", RT_OK,     OK_NOSUCHART,
    "500", RT_ABORT,  NSERVERERROR,
    "501", RT_ABORT,  NSERVERERROR,
    "502", RT_ABORT,  NSERVERERROR,
    "503", RT_ABORT,  NSERVERERROR,
};

const RESP smtp_responses[] =
{
    "500",  RT_ABORT,  SSERVERERROR,
    "501",  RT_ABORT,  SSERVERERROR,
    "503",  RT_ABORT,  SSERVERERROR,
    "504",  RT_ABORT,  SSERVERERROR,
    "220",  RT_OK,     OK_OK,
    "221",  RT_ABORT,  SSERVERERROR,
    "421",  RT_ABORT,  SSERVERERROR,
    "250",  RT_OK,     OK_OK,
    "251",  RT_OK,     OK_OK,
    "450",  RT_ABORT,  SSERVERERROR,
    "550",  RT_ABORT,  SSERVERERROR,
    "451",  RT_ABORT,  SSERVERERROR,
    "551",  RT_ABORT,  SSERVERERROR,
    "452",  RT_ABORT,  SSERVERERROR,
    "552",  RT_ABORT,  SSERVERERROR,
    "553",  RT_ABORT,  SSERVERERROR,
    "354",  RT_OK,     OK_OK,
    "554",  RT_ABORT,  SSERVERERROR,
};


#endif //__RESPONSES_H
