/*
 * structures and definitions for the int 15, ax=e820 memory map
 * scheme.
 *
 * In a nutshell, arch/i386/boot/setup.S populates a scratch table
 * in the empty_zero_block that contains a list of usable address/size
 * duples.   In arch/i386/kernel/setup.c, this information is
 * transferred into the e820map, and in arch/i386/mm/init.c, that
 * new information is used to mark pages reserved or not.
 *
 */
#ifndef __E820_HEADER
#define __E820_HEADER

#define E820MAP	0x2d0		/* our map */
#define E820MAX	32		/* number of entries in E820MAP */
#define E820NR	0x1e8		/* # entries in E820MAP */

#define E820_RAM	1	/* Memory available to OS. */
#define E820_RESERVED	2	/* Memory reserved for BIOS. */
#define E820_ACPI	3	/* Memory for ACPI. */
#define E820_NVS	4	/* Memory for NVS. */

/* Memory available to OS. */
#define E820_AVAILABLE	0x80000000

/* Memory region is ok. */
#define E820_REG_OK(m)	((m).addrhigh == 0x0 && (m).sizehigh == 0x0)

/* Memory region type is ok. */
#define E820_TYPE_OK(m)	((m).type == E820_RAM)

#ifndef __ASSEMBLY__

struct e820map {
    int nr_map;
    struct {
	/* low 4 bytes of start of memory segment */
	unsigned long addrlow;
	/* high 4 bytes of start of memory segment */
	unsigned long addrhigh;
	/* low 4 bytes of  size of memory segment */
	unsigned long sizelow;
	/* high 4 bytes of  size of memory segment */
	unsigned long sizehigh;
	/* type of memory segment */
	unsigned long type;
    } map[E820MAX];
};

extern struct e820map e820;
#endif/*!__ASSEMBLY__*/

#endif/*__E820_HEADER*/
